package com.ejie.aa17a.service.impl;

import java.math.BigDecimal;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejie.aa17a.dao.iface.Aa17aDatoHistoricoDao;
import com.ejie.aa17a.model.Aa17aDatoHistorico;
import com.ejie.aa17a.service.iface.Aa17aDatoHistoricoService;

/**
 * Aa17aDatoHistoricoServiceImpl generated by UDA, 18-dic-2013 15:36:14.
 * 
 * @author UDA
 */

public class Aa17aDatoHistoricoServiceImpl implements Aa17aDatoHistoricoService {

	private static final Logger logger = LoggerFactory.getLogger(Aa17aDatoHistoricoServiceImpl.class);

	private Aa17aDatoHistoricoDao aa17aDatoHistoricoDao;

	/**
	 * Devuelve los datos historicos para cargar el grafico
	 * 
	 * @param aa17adatohistorico
	 *            Aa17aDatoHistorico
	 * @return List
	 */
	public List<BigDecimal[]> getDatosHistorico(Aa17aDatoHistorico aa17adatohistorico) {
		return (List<BigDecimal[]>) this.aa17aDatoHistoricoDao.getDatosHistorico(aa17adatohistorico);
	}

	/**
	 * Devuelve el máximo idBanda del dia anterior al actual de los datos
	 * historicos de una estacion
	 * 
	 * @param idEstacion
	 *            Long
	 * @return Long
	 */
	public Long getMaxIdBandaEstacion(Long idEstacion) {
		return (Long) this.aa17aDatoHistoricoDao.getMaxIdBandaEstacion(idEstacion);
	}

	/**
	 * Devuelve el idBanda del dia anterior al actual de los datos historicos de
	 * una estacion y un contaminante
	 * 
	 * @param datoHistorico
	 *            Aa17aDatoHistorico
	 * @return Long
	 */
	public Long getIdBandaContaminante(Aa17aDatoHistorico datoHistorico) {
		return (Long) this.aa17aDatoHistoricoDao.getIdBandaContaminante(datoHistorico);
	}

	/**
	 * Setter method for Aa17aDatoHistoricoDao.
	 * 
	 * @param aa17aDatoHistoricoDao
	 *            Aa17aDatoHistoricoDao
	 * @return
	 */
	public void setAa17aDatoHistoricoDao(Aa17aDatoHistoricoDao aa17aDatoHistoricoDao) {
		Aa17aDatoHistoricoServiceImpl.logger.info("Setting Dependency " + aa17aDatoHistoricoDao);
		this.aa17aDatoHistoricoDao = aa17aDatoHistoricoDao;
	}

	/**
	 * Devuelve los datos historicos en una lista de beans
	 * 
	 * @param aa17adatohistorico
	 *            Aa17aDatoHistorico
	 * @return List<Aa17aDatoHistorico>
	 */
	public List<Aa17aDatoHistorico> listDatosHistoricos(Aa17aDatoHistorico aa17adatohistorico) {
		return (List<Aa17aDatoHistorico>) this.aa17aDatoHistoricoDao.listDatosHistoricos(aa17adatohistorico);
	}
}
